﻿$(document).on("pageinit", function () {
    var context = $("[data-questiontype='checkbox'],[data-questiontype='choicegrid'],[data-questiontype='hybridgrid']");

    $(":checkbox", context).each(function () {
        checkMaxAnswer($(this));
    });

    $(":checkbox", context).on("change", function () {
        ToggleOpenEndMobile($(this));

        var container = $(this).closest(".questionContainer");
        var choices;

        if ($(this).is("[data-exclusive=true]")) {
            // Uncheck all other checkbox that have the same name
            choices = $(':checkbox[name=' + $(this).attr('name') + '][value!=' + $(this).val() + ']', container);
        } else {
            // Uncheck all other checkbox that have the same name and that are exclusive
            choices = $(':checkbox[data-exclusive=true][name=' + $(this).attr('name') + '][value!=' + $(this).val() + ']', container);
        }

        if (choices) {
            choices.each(function () {
                $(this).prop('checked', false).checkboxradio("refresh");
                ToggleOpenEndMobile($(this));
            });
        }

        checkMaxAnswer($(this));
    });

    $(".softPromptChoice:not(input[type=option])", context).each(function () {
        $(this).parent().addClass("softPromptChoice");
    });

    if (updateMobileSoftPromptDisplay) updateMobileSoftPromptDisplay(context);
});

function checkMaxAnswer(element) {
    var choiceList = element.closest(".choiceList");
    var content = (choiceList.length > 0) ? element.closest(".choiceList") : element.closest("fieldset");
    var maxAnswers = content.attr("data-maxanswers");

    if (maxAnswers) {
        var checked = $('input:checkbox:checked', content).length;

        if (checked == parseInt(maxAnswers)) {
            var $inputOverMax = $("input:checkbox:not(:checked)", content);
            $inputOverMax.prop("disabled", true);
            $inputOverMax.closest("div.ui-checkbox").addClass("maxDisabled");
            $("input:checkbox:not(:checked)", content).prop("disabled", true);
        }
        else {
            $("input:checkbox:not(:checked)", content).prop("disabled", false);
            $("div.ui-checkbox", content).removeClass("maxDisabled");
        }
    }
}